C      *****************************************************************
C      * Subroutine ChargeBal                                          *
C      * Given a set of species concentrations, calculate the ionic    *
C      * strength and ionic charge balance for the aqueous phase.      *
C      *                                                               *
C      * Variables:                                                    *
C      * ChgBal    -Output- Net ionic charge balance.  Unitless.       *
C      * IonicStr  -Output- Ionic strength.  Units are mol/L.  (These  *
C      *                    units do not result from the calculation   *
C      *                    but are defined by usage (Morel 1983).)    *
C      * LNum      -Input - The current layer number.  Unitless.       *
C      * NSpecies  -Input - The number of species in the system (i.e.  *
C      *                    the number of components plus the number   *
C      *                    of dependent species).  Unitless.          *
C      *                    (Common block VModel, file VModel.f)       *
C      * S         -Local - Index variable.  Unitless.                 *
C      * SpConc    -Input - A matrix, of size NSpecies by NLayers, of  *
C      *                    species concentrations, one set for each   *
C      *                    layer. Units are mol/L.                    *
C      *                    (Common block VModel, file VModel.f)       *
C      * SType     -Input - A vector, of size NSpecies, of each        *
C      *                    species's type.  Unitless.                 *
C      *                    (Common block VModel, file VModel.f)       *
C      * T         -Local - Temporary variable.  Units are consistent  *
C      *                    with items being stored.                   *
C      * Z         -Input - A vector, of size NComp, of unspeciated    *
C      *                    charge for each component.  Units are      *
C      *                    equivalent charge.                         *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE CHARGEBAL(LNUM, IONICSTR, CHGBAL)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
       INTEGER LNUM, S
       REAL*8 CHGBAL, IONICSTR, T

C      *--------------------------------------------------*
C      * Calculate the ionic strength and charge balance. *
C      *--------------------------------------------------*
       IONICSTR = 0.0
       CHGBAL   = 0.0

       DO 100 S=1, NSPECIES
C         *---------------------------------------*
C         * Test to include only aqueous species. *
C         *---------------------------------------*
          IF (STYPE(S).LE.SOLGAS) THEN
             T = SPCONC(S,LNUM) * Z(S)
             CHGBAL = CHGBAL + T
             IONICSTR = IONICSTR + T * Z(S)
          END IF
  100  CONTINUE

       IONICSTR = IONICSTR * 0.5
          

	      RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
